***********************************
* Get stats from Lalonde
***********************************

clear all
set matsize 10000
capture log close
log using Lalonde.log, replace

**Delineate samples
use nswre74
gen sample=0 if treat==1 //experimental treatments
replace sample=1 if treat==0 //experimental controls

append using cps1re74  //CPS1 controls
drop if treat==1&sample==. // don't duplicate experimental treatments
replace sample=2 if sample==.

tab sample, miss



preserve

set seed 12345
mat B=J(1001,3,.)

forvalues i=1/1001{
qui{
probit treat re74 re75 age age2 ed black hisp nodeg married if sample==0|sample==2
predict phat


**Get Estimates
reg re78 treat if sample<=1
mat B[`i',1]=_b[treat]
reg re78 treat re74 re75 age age2 ed black hisp nodeg married if sample==0|sample==2 //CPS1 controls
mat B[`i',2]=_b[treat]
reg re78 treat re74 re75 age age2 ed black hisp nodeg married if (sample==0|sample==2)&(phat>.1&phat<.9) //CPS1 p-score screened
mat B[`i',3]=_b[treat]	
}
restore, preserve
bsample
}

svmat B
list B* if _n==1 //full sample estimates
lab var B1 "NSW"
lab var B2 "CPS1"
lab var B3 "CPS1 screened"
sum B1-B3 if _n>1 //std errs

corr B1-B3 if _n>1 //correlations

log close
